﻿WITH    parametre (limite,nieme) AS (VALUES (CAST(10000 AS BIGINT),1000)),
        genere_nombre (nombre_genere) AS 
(SELECT generate_series FROM generate_series(1,(SELECT limite FROM parametre))),
        premiers_nombres_premiers (premier) AS 
(VALUES (CAST(2 AS BIGINT)),(3),(5),(7),(11),(13),(17),(19),(23),(29),
             (31),(37),(41),(43),(47),(53),(59),(61),(67),(71)),        
        divise (diviseur) AS
        -- Utilise le principe du crible d'Eratostène pour maximiser les recherches  
        -- en supprimant les multiples des 20 premiers nombres premiers
(SELECT premier FROM premiers_nombres_premiers
 UNION
(SELECT nombre_genere FROM genere_nombre
 EXCEPT
 SELECT nombre_genere*premier
 FROM   genere_nombre CROSS JOIN premiers_nombres_premiers
 WHERE  nombre_genere<=(SELECT limite FROM parametre)/premier) ORDER  BY 1),
        genere_nombre_premier(nombre,premier) AS
(SELECT scan_nombre.nombre_genere AS "Nombre premier",
        COUNT(*) OVER (PARTITION BY scan_nombre.nombre_genere ORDER BY scan_nombre.nombre_genere)=1 
 FROM   divise JOIN genere_nombre scan_nombre ON MOD(scan_nombre.nombre_genere, diviseur)=0 
                                        AND diviseur <= CAST(sqrt(scan_nombre.nombre_genere) AS INTEGER)
 WHERE  scan_nombre.nombre_genere<=(SELECT limite FROM parametre) AND scan_nombre.nombre_genere>=2),
        ordre_nombre_premier (rang,nombre) AS 
(SELECT rank() OVER (ORDER BY nombre),nombre FROM genere_nombre_premier WHERE premier)
 SELECT nombre FROM ordre_nombre_premier WHERE rang=(SELECT nieme FROM parametre);